<?php
require_once '../config/db.php';

try {
    // Drop existing triggers if they exist
    $pdo->exec("DROP TRIGGER IF EXISTS before_refund_item_insert");
    $pdo->exec("DROP TRIGGER IF EXISTS before_refund_item_update");
    $pdo->exec("DROP TRIGGER IF EXISTS after_refund_insert");

    // Create trigger for refund items insert
    $pdo->exec("CREATE TRIGGER before_refund_item_insert
        BEFORE INSERT ON refund_items
        FOR EACH ROW
        BEGIN
            IF NEW.condition IN ('Damaged', 'Opened', 'Other') THEN
                SET NEW.manual_amount = NEW.total_price;
            ELSE
                SET NEW.manual_amount = NEW.unit_price * NEW.quantity;
            END IF;
        END");

    // Create trigger for refund items update
    $pdo->exec("CREATE TRIGGER before_refund_item_update
        BEFORE UPDATE ON refund_items
        FOR EACH ROW
        BEGIN
            IF NEW.condition IN ('Damaged', 'Opened', 'Other') THEN
                SET NEW.manual_amount = NEW.total_price;
            ELSE
                SET NEW.manual_amount = NEW.unit_price * NEW.quantity;
            END IF;
        END");

    // Create trigger for refund receipt number
    $pdo->exec("CREATE TRIGGER after_refund_insert
        AFTER INSERT ON refunds
        FOR EACH ROW
        BEGIN
            UPDATE refunds 
            SET refund_receipt_no = CONCAT('REF', LPAD(NEW.id, 6, '0'))
            WHERE id = NEW.id;
        END");

    echo "Database update completed successfully!";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
} 